/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apiipc.generated.enums.ConnectType;
import apiipc.ipc.IPCEvent;

public abstract class LogicalWorkspaceEvent
extends IPCEvent {
    public EventType type;

    public LogicalWorkspaceEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DEVICE_ADDED,
        DEVICE_REMOVED,
        REMOTE_NETWORK_ADDED,
        REMOTE_NETWORK_REMOVED,
        LINK_CREATED,
        LINK_DELETED;

    }

    public static class LinkDeleted
    extends LogicalWorkspaceEvent {
        public String deviceName1;
        public String portName1;
        public String deviceName2;
        public String portName2;
        public ConnectType connType;

        public LinkDeleted(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINK_DELETED;
            this.deviceName1 = (String)iPCEventLTV.getEventParameters().get(0);
            this.portName1 = (String)iPCEventLTV.getEventParameters().get(1);
            this.deviceName2 = (String)iPCEventLTV.getEventParameters().get(2);
            this.portName2 = (String)iPCEventLTV.getEventParameters().get(3);
            this.connType = ConnectType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName1 = " + this.deviceName1 + "\n\tportName1 = " + this.portName1 + "\n\tdeviceName2 = " + this.deviceName2 + "\n\tportName2 = " + this.portName2 + "\n\tconnType = " + (Object)((Object)this.connType);
        }
    }

    public static class LinkCreated
    extends LogicalWorkspaceEvent {
        public String deviceName1;
        public String portName1;
        public String deviceName2;
        public String portName2;
        public ConnectType connType;

        public LinkCreated(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINK_CREATED;
            this.deviceName1 = (String)iPCEventLTV.getEventParameters().get(0);
            this.portName1 = (String)iPCEventLTV.getEventParameters().get(1);
            this.deviceName2 = (String)iPCEventLTV.getEventParameters().get(2);
            this.portName2 = (String)iPCEventLTV.getEventParameters().get(3);
            this.connType = ConnectType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName1 = " + this.deviceName1 + "\n\tportName1 = " + this.portName1 + "\n\tdeviceName2 = " + this.deviceName2 + "\n\tportName2 = " + this.portName2 + "\n\tconnType = " + (Object)((Object)this.connType);
        }
    }

    public static class RemoteNetworkRemoved
    extends LogicalWorkspaceEvent {
        public String name;

        public RemoteNetworkRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.REMOTE_NETWORK_REMOVED;
            this.name = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class RemoteNetworkAdded
    extends LogicalWorkspaceEvent {
        public String name;

        public RemoteNetworkAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.REMOTE_NETWORK_ADDED;
            this.name = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class DeviceRemoved
    extends LogicalWorkspaceEvent {
        public String name;

        public DeviceRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DEVICE_REMOVED;
            this.name = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class DeviceAdded
    extends LogicalWorkspaceEvent {
        public String name;
        public String model;

        public DeviceAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DEVICE_ADDED;
            this.name = (String)iPCEventLTV.getEventParameters().get(0);
            this.model = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tname = " + this.name + "\n\tmodel = " + this.model;
        }
    }
}

